#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

//#define _TRAME_

static FbVertex pVertexIn[] =
{
#ifdef _TRAME_
	{-320,-240,0,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
	{320,-240,0,  0.f,0,0,   0,0,0.f, {256.f, 0.f, 0.f}},
	{320,240,0,  0.f,0,0,   0,0,0.f, {256.f, 200.f, 0.f}},
	{-320,240,0,  0.f,0,0,   0,0,0.f, {0.f, 200.f, 0.f}},
#else
	{-320,-240,0,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
	{320,-240,0,  0.f,0,0,   0,0,0.f, {256.f, 0.f, 0.f}},
	{320,240,0,  0.f,0,0,   0,0,0.f, {256.f, 100.f, 0.f}},
	{-320,240,0,  0.f,0,0,   0,0,0.f, {0.f, 100.f, 0.f}},
#endif
};
static GrVertex pVertexOut[sizeof(pVertexIn)/sizeof(FbVertex)];
static Face pFace[] =
{
	{0,1,2},
	{2,3,0},
};
static Obj3d Panneau = 
{
	pVertexIn,
	pVertexOut,
	sizeof(pVertexIn)/sizeof(FbVertex), // Nb Vertexes
	pFace,
	sizeof(pFace)/sizeof(Face)
};

//

static FbVertex pVertexIn2[] =
{
/*
	{-320,-240,0,  0.f,0,0,   0,0,0.f, {0.f, 32.f, 0.f}},
	{320,-240,0,  0.f,0,0,   0,0,0.f, {128.f, 32.f, 0.f}},
	{320,240,0,  0.f,0,0,   0,0,0.f, {128.f, 0.f, 0.f}},
	{-320,240,0,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}}
	*/
	{-320,-180,0,  0.f,0,0,   0,0,0.f, {0.f, 32.f, 0.f}},
	{320,-180,0,  0.f,0,0,   0,0,0.f, {128.f, 32.f, 0.f}},
	{320,180,0,  0.f,0,0,   0,0,0.f, {128.f, 0.f, 0.f}},
	{-320,180,0,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}}
};
static GrVertex pVertexOut2[sizeof(pVertexIn)/sizeof(FbVertex)];
static Face pFace2[] =
{
	{0,1,2},
	{2,3,0},
};
static Obj3d Panneau2 = 
{
	pVertexIn2,
	pVertexOut2,
	sizeof(pVertexIn2)/sizeof(FbVertex), // Nb Vertexes
	pFace,
	sizeof(pFace2)/sizeof(Face)
};

static float Sow1[] = {0,0,0,0,0,0,0,0, 128,128,128,128,128,128,128,128};
static float Tow1[] = {32,32,96,96,160,160,224,224, 32,32,96,96,160,160,224,224};
static float Sow2[] = {128,128,128,128,128,128,128,128, 256,256,256,256,256,256,256,256};
static float Tow2[] = {32,32,96,96,160,160,224,224, 32,32,96,96,160,160,224,224};
static float Sow3[] = {128,128,128,128,128,128,128,128, 256,256,256,256,256,256,256,256};
static float Tow3[] = {0,64,64,128,128,192,192,256, 0,64,64,128,128,192,192,256};
static float Sow4[] = {0,0,0,0,0,0,0,0, 128,128,128,128,128,128,128,128};
static float Tow4[] = {0,64,64,128,128,192,192,256, 0,64,64,128,128,192,192,256};


//
static float Sow5[] = {0,0,0,0,0,0,0,0, 128,128,128,128,128,128,128,128};
static float Tow5[] = {0,32,64,96,128,160,196,224, 0,32,64,96,128,160,196,224};
static float Sow6[] = {128,128,128,128,128,128,128,128, 256,256,256,256,256,256,256,256};
static float Tow6[] = {0,32,64,96,128,160,196,224, 0,32,64,96,128,160,196,224};
static float Sow7[] = {128,128,128,128,128,128,128,128, 256,256,256,256,256,256,256,256};
static float Tow7[] = {32,64,96,128,160,196,224,256, 32,64,96,128,160,196,224,256};
static float Sow8[] = {0,0,0,0,0,0,0,0, 128,128,128,128,128,128,128,128};
static float Tow8[] = {32,64,96,128,160,196,224,256, 32,64,96,128,160,196,224,256};


//

#define FOND_Z 1.f
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Mec1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Mec2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{128,0,1.f/300.f}};
static GrVertex Mec3 = {640.f,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{128,32,1.f/FOND_Z}};
static GrVertex Mec4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,32,1.f/FOND_Z}};

static FILE *vdofile;
static float Matrix[16], Matrix2[16];

void LInit_Greets()
{
	PrepareTextureFromArray(g_PicGreets, 256, 256, &g_TextureGreets);
	PrepareTextureFromArray(g_PicMecs, 256, 256, &g_TextureMecs);
}

void QInit_Greets()
{
	//grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_LOCAL,
		 GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grCullMode(GR_CULL_DISABLE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	grConstantColorValue(0xff0000);
	//grConstantColorValue(0xff8080);

	g_TextureBuff.info.format = GR_TEXFMT_INTENSITY_8;
	memset(g_FrameBuf3d, 0, 65536);

	DownloadTexture(&g_TextureGreets);
	DownloadTexture(&g_TextureMecs);

	vdofile = fopen(VideoName, "rb");
}

void Effect_Greets()
{
	int Cpt1;
	int Count;
	static int OldCount = -1;
	static BYTE Trame[256*100];
	DWORD h,w;
	DWORD dwRed, dwGreen, dwBlue;

	static DWORD dwSubName = 0;
	static DWORD dwName = 0;
	static DWORD dwMec = 0;
	static DWORD dwSubMec = 2048*16;
	DWORD dwTmp;
	static float x,y;
	float fLen;

	Count = (g_demostate.TickInEffect)*568.f/56.f/1000.f;
	while(Count >= 568)
		Count -= 568;

	if (
	    
		(OldCount != Count)
		&&
		(Count<568)
		)
	{		
		OldCount = Count;
		fseek(vdofile, VideoSeek[Count], SEEK_SET);
		LoadJpeg2ArrayPrealloc(&Trame[0], vdofile, &h, &w);
#ifdef _TRAME_
		for(Cpt1=0;Cpt1<100;Cpt1++)
		{
			memcpy(((BYTE*)g_FrameBuf3d)+Cpt1*256*2, Trame+Cpt1*256, 256);
		}
#else
		memcpy(g_FrameBuf3d, Trame, 256*100);
#endif
		grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
						g_TextureBuff.evenOdd, &g_TextureBuff.info);
	
	}

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, CosTable[g_demostate.TickInEffect&8191]*1000);
	RotateYMatrix(Matrix, Matrix2, g_demostate.TickInEffect*4);
	RotateZMatrix(Matrix2, Matrix, SinTable[g_demostate.TickInEffect&8191]*500);
	TranslateMatrix(Matrix2, 0, 0, 500);

	grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
		 GR_COMBINE_FACTOR_ONE,
		 GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_NONE, FXFALSE);
	grConstantColorValue(31);

	grColorMask(FXTRUE, FXTRUE);

	//grConstantColorValue(36<<24);
	grConstantColorValue(36<<24);
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_ZERO,
		 GR_COMBINE_FACTOR_ZERO,
		 GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	SelectTexture(g_TextureBuff);
	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);

/* 	dwRed = 128+127*CosTable[(g_demostate.TickInEffect*4)&8191]; */
/* 	dwGreen = 128+127*CosTable[((g_demostate.TickInEffect*4)+2700)&8191]; */
/* 	dwBlue = 128+127*CosTable[((g_demostate.TickInEffect*4)+5400)&8191]; */
/* 	grConstantColorValue((dwRed<<16)|(dwGreen<<8)|dwBlue); */
	grConstantColorValue(0xff0080);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_LOCAL,
		 GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	SelectTexture(g_TextureBuff);
	DrawWithMatrix(&Panneau, Matrix2, 0, 0, 0);

	//
	if (g_demostate.TickInEffect<2048*16)
	{
		BeIdentityMatrix(Matrix);
		RotateXMatrix(Matrix2, Matrix,
				  g_demostate.TickInEffect*2+2048+1024*SinTable[(g_demostate.TickInEffect*4)&8191]);
		ScaleXMatrix(&Matrix2, 4+3.f*CosTable[(g_demostate.TickInEffect*4)&8191]);
		TranslateMatrix(Matrix2, 0, 0, 400);

		if(dwSubName+2048<g_demostate.TickInEffect)
		  {
		  dwSubName += 2048;
		  dwName = (dwName+1)&15;
		  pVertexIn2[0].tmuvtx[0].sow = Sow1[dwName];
		  pVertexIn2[0].tmuvtx[0].tow = Tow1[dwName];
		  pVertexIn2[1].tmuvtx[0].sow = Sow2[dwName];
		  pVertexIn2[1].tmuvtx[0].tow = Tow2[dwName];
		  pVertexIn2[2].tmuvtx[0].sow = Sow3[dwName];
		  pVertexIn2[2].tmuvtx[0].tow = Tow3[dwName];
		  pVertexIn2[3].tmuvtx[0].sow = Sow4[dwName];
		  pVertexIn2[3].tmuvtx[0].tow = Tow4[dwName];
		}

	/*grAlphaBlendFunction(GR_BLEND_ONE_MINUS_SRC_COLOR, GR_BLEND_ONE_MINUS_DST_COLOR, 
		GR_BLEND_ZERO, GR_BLEND_ZERO);*/
		grConstantColorValue(0xff00);
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
			 GR_COMBINE_FACTOR_LOCAL,
			 GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		SelectTexture(g_TextureGreets);
		DrawWithMatrix(&Panneau2, Matrix2, 0, 0, 0);
	}
	else
	{
		// 16 * 2048 = 32768
		// 8 * 5000 = 40000
		if(dwSubMec+512<g_demostate.TickInEffect)
		{
			dwSubMec += 512;
			dwMec = (dwMec+1)%10;

			x = CosTable[(dwMec*3500)&8191]*160.f+160.f;
			y = SinTable[(dwMec*3000)&8191]*120.f+120.f;

			Mec1.tmuvtx[0].sow = Sow5[dwMec]; Mec1.tmuvtx[0].tow = Tow5[dwMec];		
			Mec2.tmuvtx[0].sow = Sow6[dwMec]; Mec2.tmuvtx[0].tow = Tow6[dwMec];
			Mec3.tmuvtx[0].sow = Sow7[dwMec]; Mec3.tmuvtx[0].tow = Tow7[dwMec];
			Mec4.tmuvtx[0].sow = Sow8[dwMec]; Mec4.tmuvtx[0].tow = Tow8[dwMec];
		}

		fLen = (dwSubMec+512-g_demostate.TickInEffect)/4;
		Mec1.x = 0+x-fLen; Mec1.y = 0+y;		
		Mec2.x = 320+x+fLen; Mec2.y = 0+y;
		Mec3.x = 320+x+fLen; Mec3.y = 100+y;
		Mec4.x = 0+x-fLen; Mec4.y = 100+y;

		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
			 GR_COMBINE_FACTOR_LOCAL,
			 GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

		dwTmp = SinTable[((g_demostate.TickInEffect-dwSubMec)*8)&8191]*128.f+128;
		dwTmp = CLIP_DW(dwTmp);
		grConstantColorValue(dwTmp<<8);

		SelectTexture(g_TextureMecs);
		guDrawTriangleWithClip(&Mec1, &Mec2, &Mec3);
		guDrawTriangleWithClip(&Mec3, &Mec4, &Mec1);
	}

	grColorMask(FXFALSE, FXFALSE);
}

void ByeBye_Greets()
{
	FreeTexture(&g_TextureMecs);
	FreeTexture(&g_TextureGreets);
	fclose(vdofile);
	grColorMask(FXTRUE, FXTRUE);
}
